/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.goals;

import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.init.data.MGConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class TeleportToOwnerGoal
extends Goal {
    private final AbstractGolemEntity<?, ?> golem;
    private final LevelReader level;
    private final PathNavigation navigation;
    private final boolean canFly;

    public TeleportToOwnerGoal(AbstractGolemEntity<?, ?> golem) {
        this(golem, false);
    }

    private TeleportToOwnerGoal(AbstractGolemEntity<?, ?> golem, boolean fly) {
        this.golem = golem;
        this.level = golem.m_9236_();
        this.navigation = golem.m_21573_();
        this.canFly = fly;
    }

    public boolean m_8036_() {
        if (this.golem.isInSittingPose() || !this.golem.getMode().isMovable()) {
            return false;
        }
        if (this.golem.m_21523_()) {
            return false;
        }
        Vec3 target = this.golem.getTargetPos();
        double maxDist = (Double)MGConfig.COMMON.maxWanderRadius.get();
        return this.golem.m_20238_(target) >= maxDist * maxDist;
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8056_() {
        this.teleportToOwner();
    }

    public void m_8041_() {
        this.navigation.m_26573_();
    }

    private void teleportToOwner() {
        BlockPos blockpos = BlockPos.m_274446_((Position)this.golem.getTargetPos());
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            this.golem.m_6710_(null);
            return;
        }
    }

    private boolean maybeTeleportTo(int pX, int pY, int pZ) {
        Entity entity;
        Vec3 target = this.golem.getTargetPos();
        if (Math.abs((double)pX - target.m_7096_()) < 2.0 && Math.abs((double)pZ - target.m_7094_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(pX, pY, pZ))) {
            return false;
        }
        LivingEntity e = this.golem;
        while ((entity = e.m_275832_()) instanceof LivingEntity) {
            LivingEntity le;
            e = le = (LivingEntity)entity;
        }
        e.m_7678_((double)pX + 0.5, (double)pY, (double)pZ + 0.5, this.golem.m_146908_(), this.golem.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pPos) {
        boolean allow;
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pPos.m_122032_());
        boolean bl = allow = blockpathtypes == BlockPathTypes.WALKABLE;
        if (this.golem.hasFlag(GolemFlags.FLOAT) || this.golem.hasFlag(GolemFlags.SWIM)) {
            allow |= blockpathtypes == BlockPathTypes.WATER;
            allow |= blockpathtypes == BlockPathTypes.WATER_BORDER;
        }
        if (!allow) {
            return false;
        }
        BlockState blockstate = this.level.m_8055_(pPos.m_7495_());
        if (!this.canFly && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pPos.m_121996_((Vec3i)this.golem.m_20183_());
        return this.level.m_45756_(this.golem, this.golem.m_20191_().m_82338_(blockpos));
    }

    private int randomIntInclusive(int pMin, int pMax) {
        return this.golem.m_217043_().m_188503_(pMax - pMin + 1) + pMin;
    }
}

